
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class School : PI.FM.N000.Base.BL.DBD.BaseTable<BO.School>
    {
        #region Static factory
        private static School _factory = null;

        public static School DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new School();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_School";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("AddressLine1", "AddressLine1"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("AddressLine2", "AddressLine2"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("PostCode", "PostCode"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Town", "Town", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Tel", "Tel"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Fax", "Fax"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Email", "Email"));
        }
        #endregion

    #region Commands definition
    public enum Commands
    {
        RestoreBySearch = 10
    }
    #endregion

    #region Get Commands
    protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
    {
      switch (CommandID)
      {
          case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
      }
      
      return base.DoGetCommand(CommandID);
    }
    #endregion

    #region Additional Commands Classes
    class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.School>
    {
      public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.School.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

      protected override void InitializeParametrs()
      {
          Add(new Gemini.Core.BL.DBD.Param("ID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
          Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
          Add(new Gemini.Core.BL.DBD.Param("Town", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
          Add(new Gemini.Core.BL.DBD.Param("Address", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
      }

      protected override void InitializeCommandText()
      {
          _commandText = "PIZB1200_School_RestoreBySearch";
      }
    }
    #endregion
    }
}
